<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:strip-space elements="*"/>
<xsl:output method="html" encoding="ISO-8859-1" indent="yes" doctype-system="http://www.w3.org/TR/REC-html4/strict.dtd" doctype-public="-//W3C//DTD HTML 4.01//EN"/>
  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>
  <xsl:template match="SevillaRpt">
    <xsl:apply-templates/>
  </xsl:template>
  <xsl:template match="Report">
    <xsl:apply-templates/>
  </xsl:template>
  <xsl:template match="GroupReport">
    <xsl:apply-templates/>
  </xsl:template>
  <xsl:template match="Group">
		<xsl:variable name="CURRENTROUND">
			<xsl:value-of select="ActRound + 1"/>
		</xsl:variable>
		<html>
      <head>
        <title>
          <xsl:value-of select="Name"/>
        </title>
				<link rel="stylesheet" type="text/css" href="cpl.css"/>
      </head>
      <body>
        <h2>
          <xsl:value-of select="../../Name"/>
        </h2>
				<xsl:apply-templates select="Round[ID &lt; ($CURRENTROUND - 1)]">
					<xsl:sort data-type="number" select="ID" order="descending"/>
				</xsl:apply-templates>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="Round">
		<div><br/></div>
    <table border="1" class="level1">
      <caption class="cplcap">
				<xsl:text>Round </xsl:text>
				<xsl:value-of select="ID+1"/>
    		<xsl:text>, </xsl:text>
 				<xsl:value-of select="Date"/>
      </caption>
      <colgroup>
      	<col class="w36"/>
      	<col class="w36"/>
      	<col/>
      </colgroup>
      <tr>
        <td>
          <table border="0" class="level2">
            <caption class="cplcap">Internal games</caption>
            <tr>
              <th class="la">White</th>
              <th class="la">Black</th>
              <th>Res</th>
            </tr>
            <xsl:apply-templates select="Game"/>
          </table>
        </td>
        <td>
          <table border="0" class="level2">
            <caption class="cplcap">External games</caption>
            <tr>
              <th class="la">White</th>
              <th class="la">Black</th>
              <th>Res</th>
            </tr>
            <xsl:apply-templates select="Abs[Reason=15]">
							<xsl:sort data-type="number" select="ExtOpponent"/>
            </xsl:apply-templates>
          </table>
        </td>
        <td>
          <table border="0" class="level2">
            <caption class="cplcap">Other</caption>
            <tr>
              <th class="la">Naam</th>
              <th> </th>
            </tr>
            <xsl:apply-templates select="Abs[Reason!=15]"/>
          </table>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template match="Game">
    <tr>
      <xsl:variable name="WHITEID">
        <xsl:value-of select="White"/>
      </xsl:variable>
      <xsl:variable name="WHITEFIRSTNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$WHITEID]/First"/>
      </xsl:variable>
      <xsl:variable name="WHITECONJNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$WHITEID]/Prefix"/>
      </xsl:variable>
      <xsl:variable name="WHITELASTNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$WHITEID]/Last"/>
      </xsl:variable>
      <td class="la">
        <xsl:value-of select="$WHITEFIRSTNAME"/>
        <xsl:text>
        </xsl:text>
        <xsl:value-of select="$WHITECONJNAME"/>
        <xsl:text>
        </xsl:text>
        <xsl:value-of select="$WHITELASTNAME"/>
      </td>
      <xsl:variable name="BLACKID">
        <xsl:value-of select="Black"/>
      </xsl:variable>
      <xsl:variable name="BLACKFIRSTNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$BLACKID]/First"/>
      </xsl:variable>
      <xsl:variable name="BLACKCONJNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$BLACKID]/Prefix"/>
      </xsl:variable>
      <xsl:variable name="BLACKLASTNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$BLACKID]/Last"/>
      </xsl:variable>
      <td class="la">
        <xsl:value-of select="$BLACKFIRSTNAME"/>
        <xsl:text>
        </xsl:text>
        <xsl:value-of select="$BLACKCONJNAME"/>
        <xsl:text>
        </xsl:text>
        <xsl:value-of select="$BLACKLASTNAME"/>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="Res='0'">gen</xsl:when>
          <xsl:when test="Res='1'">1-0</xsl:when>
          <xsl:when test="Res='2'">-</xsl:when>
          <xsl:when test="Res='3'">0-1</xsl:when>
        </xsl:choose>
      </td>
    </tr>
  </xsl:template>
  <xsl:template match="Abs[Reason!=15]">
    <tr>
      <xsl:variable name="PLAYERID">
        <xsl:value-of select="Player"/>
      </xsl:variable>
      <xsl:variable name="FIRSTNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$PLAYERID]/First"/>
      </xsl:variable>
      <xsl:variable name="CONJNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$PLAYERID]/Prefix"/>
      </xsl:variable>
      <xsl:variable name="LASTNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$PLAYERID]/Last"/>
      </xsl:variable>
      <td class="la">
        <xsl:value-of select="$FIRSTNAME"/>
        <xsl:text>
        </xsl:text>
        <xsl:value-of select="$CONJNAME"/>
        <xsl:text>
        </xsl:text>
        <xsl:value-of select="$LASTNAME"/>
      </td>
      <xsl:choose>
        <xsl:when test="Reason='0'">
          <td>Abs. n.m.</td>
        </xsl:when>
        <xsl:when test="Reason='1'">
          <td>Absent</td>
        </xsl:when>
        <xsl:when test="Reason='2'">
          <td>Club</td>
        </xsl:when>
        <xsl:when test="Reason='3'">
          <td>Club other day</td>
        </xsl:when>
        <xsl:when test="Reason='4'">
          <td>No member</td>
        </xsl:when>
        <xsl:when test="Reason='5' or Reason='16'">
          <td>Bye</td>
        </xsl:when>
        <xsl:when test="Reason='9' or Reason='16'">
          <td>1R</td>
        </xsl:when>
        <xsl:when test="Reason='10' or Reason='16'">
          <td>R</td>
        </xsl:when>
        <xsl:when test="Reason='11' or Reason='16'">
          <td>0R</td>
        </xsl:when>
        <xsl:when test="Reason='17'">
          <td>0R</td>
        </xsl:when>
        <xsl:otherwise>
          <td class="special">
            <xsl:value-of select="Reason"/>
          </td>
        </xsl:otherwise>
      </xsl:choose>
    </tr>
  </xsl:template>
  <xsl:template match="Abs[Reason=15]">
    <tr>
      <xsl:variable name="EPLAYERID">
        <xsl:value-of select="Player"/>
      </xsl:variable>
      <xsl:variable name="EFIRSTNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$EPLAYERID]/First"/>
      </xsl:variable>
      <xsl:variable name="ECONJNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$EPLAYERID]/Prefix"/>
      </xsl:variable>
      <xsl:variable name="ELASTNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$EPLAYERID]/Last"/>
      </xsl:variable>
			<xsl:variable name="EXTOPPID">
				<xsl:value-of select="ExtOpponent"/>
			</xsl:variable>
			<xsl:variable name="EXTTEAM">
				<xsl:value-of select="floor(ExtOpponent div 8)+1"/>
			</xsl:variable>
			<xsl:variable name="EXTBORD">
				<xsl:value-of select="floor(ExtOpponent - 8 *($EXTTEAM - 1))+1"/>
			</xsl:variable>
			<td class="la">
				<xsl:choose>
					<xsl:when test="AbsColor &lt; 2">
						<xsl:value-of select="$EFIRSTNAME"/>
						<xsl:text>
						</xsl:text>
						<xsl:value-of select="$ECONJNAME"/>
						<xsl:text>
						</xsl:text>
						<xsl:value-of select="$ELASTNAME"/>
						<xsl:if test="AbsColor=0">
							<xsl:text>(*) </xsl:text>
						</xsl:if>
					</xsl:when>
					<xsl:when test="AbsColor=2">
						<xsl:text>Tm </xsl:text>
						<xsl:value-of select="$EXTTEAM"/>
						<xsl:text>, bd </xsl:text>
						<xsl:value-of select="$EXTBORD"/>
					</xsl:when>
				</xsl:choose>
      </td>
			<td class="la">
				<xsl:choose>
					<xsl:when test="AbsColor=2">
						<xsl:value-of select="$EFIRSTNAME"/>
						<xsl:text>
						</xsl:text>
						<xsl:value-of select="$ECONJNAME"/>
						<xsl:text>
						</xsl:text>
						<xsl:value-of select="$ELASTNAME"/>
					</xsl:when>
					<xsl:when test="AbsColor &lt; 2">
						<xsl:text>Tm </xsl:text>
						<xsl:value-of select="$EXTTEAM"/>
						<xsl:text>, bd </xsl:text>
						<xsl:value-of select="$EXTBORD"/>
					</xsl:when>
				</xsl:choose>
			</td>
			<td>
        <xsl:choose>
          <xsl:when test="(ExtResult='1' and AbsColor!='2')
          								or (ExtResult='3' and AbsColor='2')">1-0</xsl:when>
          <xsl:when test="ExtResult='2'">-</xsl:when>
          <xsl:when test="(ExtResult='1' and AbsColor='2')
          								or (ExtResult='3' and AbsColor!='2')">0-1</xsl:when>
        </xsl:choose>
			</td>
		</tr>
  </xsl:template>
  <xsl:template match="*">
  </xsl:template>
</xsl:stylesheet>
