<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:strip-space elements="*"/>
<xsl:output method="html" encoding="ISO-8859-1" indent="yes" doctype-system="http://www.w3.org/TR/REC-html4/strict.dtd" doctype-public="-//W3C//DTD HTML 4.01//EN"/>
	<xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>
  <xsl:template match="SevillaRpt">
    <xsl:apply-templates/>
  </xsl:template>
  <xsl:template match="Report">
    <html>
      <head>
        <title>
					<xsl:value-of select="Name"/>
        </title>
				<link rel="stylesheet" type="text/css" href="cpl.css"/>
      </head>
      <body>
				<xsl:apply-templates/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="GroupReport">
		<xsl:apply-templates select="Ranking"/>
		<p class="break"/>
		<xsl:apply-templates select="Group"/>
  </xsl:template>

  <xsl:template match="Ranking">
  	<div class="center">
			<table class="cpltable2" frame="box" rules="groups">
				<caption class="cplcap">
					<xsl:text> --- Indelingsmatrix </xsl:text>
					<xsl:value-of select="../../Name"/>
					<xsl:text> voor ronde </xsl:text>
					<xsl:value-of select="../Group/NrRounds"/>
					<xsl:text> ---</xsl:text>
				</caption>
				<colgroup/>
				<colgroup/>
				<xsl:apply-templates select="Player" mode="cols"/>
				<thead class="cplth">
					<tr>
						<th> </th>
						<th> </th>
						<xsl:apply-templates select="Player" mode="header"/>
					</tr>
				</thead>
				<tbody>
					<xsl:apply-templates select="Player" mode="rows"/>
				</tbody>
			</table>
		</div>
  </xsl:template>

  <xsl:template match="Player" mode="header">
    <th>
      <xsl:value-of select="(Pos + 1) mod 10"/>
    </th>
  </xsl:template>

  <xsl:template match="Player" mode="cols">
    <xsl:if test="(Pos mod 5) = 0">
      <colgroup span="5"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="Player" mode="rows">
    <xsl:variable name="PLAYERID">
      <xsl:value-of select="ID"/>
    </xsl:variable>
    <xsl:if test="(Pos>0) and (Pos mod 5) = 0">
      <xsl:text disable-output-escaping="yes">
        &lt;/tbody&gt;
        &lt;tbody&gt;
      </xsl:text>
    </xsl:if>
    <tr>
      <td class="ra">
        <xsl:value-of select="Pos+1"/>
        <xsl:text>.</xsl:text>
      </td>
      <td class="la">
        <xsl:value-of select="Name"/>
      </td>
      <xsl:apply-templates select="../Player" mode="opponent">
        <xsl:with-param name="ROWPLAYERPOS" select="Pos"/>
        <xsl:with-param name="ROWPLAYERID" select="ID"/>
      </xsl:apply-templates>
    </tr>
  </xsl:template>

  <xsl:template match="Player" mode="opponent">
    <xsl:param name="ROWPLAYERPOS"/>
    <xsl:param name="ROWPLAYERID"/>
    <xsl:variable name="SELFPLAYERPOS">
      <xsl:value-of select="Pos"/>
    </xsl:variable>
    <xsl:variable name="SELFPLAYERID">
      <xsl:value-of select="ID"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="Pos=$ROWPLAYERPOS">
        <td class="cplbgx">
          <xsl:value-of select="NBye"/>
        </td>
      </xsl:when>
      <xsl:when test="Pos&lt;$ROWPLAYERPOS">
        <td> </td>
      </xsl:when>
      <xsl:otherwise>
        <td>
          <xsl:choose>
            <xsl:when test="../../XTbl/PlayerXTbl[PlayerNr=$ROWPLAYERID]/PairXTbl[OpponentNr=$SELFPLAYERID]/Pref='-'">
              <xsl:text>-</xsl:text>
            </xsl:when>
            <xsl:when test="starts-with(../../XTbl/PlayerXTbl[PlayerNr=$ROWPLAYERID]/PairXTbl[OpponentNr=$SELFPLAYERID]/Pref,'w')">
              <xsl:text>w</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>z</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="Group">
    <xsl:variable name="CURRENTROUND">
      <xsl:value-of select="ActRound"/>
    </xsl:variable>
  	<div class="center">
			<table class="cpltable2" frame="box" rules="groups" width="40%">
				<caption class="cplcap">
					<xsl:text> --- Voorgestelde indeling </xsl:text>
					<xsl:text> ---</xsl:text>
				</caption>
				<colgroup/>
				<colgroup/>
				<thead class="cplth">
					<tr>
						<th>wit</th>
						<th>zwart</th>
					</tr>
				</thead>
				<tbody>
					<xsl:apply-templates select="Round[ID = $CURRENTROUND]"/>
				</tbody>
			</table>
		</div>
  </xsl:template>

   <xsl:template match="Round">
  <xsl:apply-templates select="Game"/>
   </xsl:template>

  <xsl:template match="Game">
    <tr>
      <xsl:variable name="WHITEID">
        <xsl:value-of select="White"/>
      </xsl:variable>
      <xsl:variable name="WHITEFIRSTNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$WHITEID]/First"/>
      </xsl:variable>
      <xsl:variable name="WHITECONJNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$WHITEID]/Prefix"/>
      </xsl:variable>
      <xsl:variable name="WHITELASTNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$WHITEID]/Last"/>
      </xsl:variable>
      <td class="la">
        <xsl:value-of select="$WHITEFIRSTNAME"/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="$WHITECONJNAME"/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="$WHITELASTNAME"/>
      </td>
      <xsl:variable name="BLACKID">
        <xsl:value-of select="Black"/>
      </xsl:variable>
      <xsl:variable name="BLACKFIRSTNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$BLACKID]/First"/>
      </xsl:variable>
      <xsl:variable name="BLACKCONJNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$BLACKID]/Prefix"/>
      </xsl:variable>
      <xsl:variable name="BLACKLASTNAME">
        <xsl:value-of select="/SevillaRpt/Report/GroupReport/Group/Player[ID=$BLACKID]/Last"/>
      </xsl:variable>
      <td class="la">
        <xsl:value-of select="$BLACKFIRSTNAME"/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="$BLACKCONJNAME"/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="$BLACKLASTNAME"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="*">
  </xsl:template>
</xsl:stylesheet>
