<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:strip-space elements="*"/>
  <xsl:output method="html" encoding="ISO-8859-1" indent="yes" doctype-system="http://www.w3.org/TR/REC-html4/strict.dtd" doctype-public="-//W3C//DTD HTML 4.01//EN"/>
  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>
  <xsl:template match="SevillaRpt">
    <xsl:apply-templates/>
  </xsl:template>
  <xsl:template match="Report">
    <html>
      <head>
        <title>
          <xsl:value-of select="Name"/>
        </title>
        <link rel="stylesheet" type="text/css" href="cpl.css"/>
        <script type="text/javascript">
          var curElementID="x";
          function toggleElementVisibility(elementID)
          {
            if( document.getElementById(elementID).style.visibility=="visible" )
            {
              document.getElementById(elementID).style.visibility = "hidden";
              curElementID="x";
            }
            else
            {
              document.getElementById(elementID).style.visibility = "visible";
              if (curElementID != "x")
              {
                document.getElementById(curElementID).style.visibility = "hidden";
              }
              curElementID=elementID;
            }
          }
        </script>
      </head>
      <body>
        <xsl:apply-templates select="GroupReport"/>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="GroupReport">
    <xsl:apply-templates select="Ranking"/>
  </xsl:template>
  <xsl:template match="Ranking">
    <table class="cpltable" frame="box" rules="groups" width="100%">
      <caption class="cplcap">
        <xsl:text> --- Ranking </xsl:text>
        <xsl:value-of select="../../Name"/>
        <xsl:text> after round </xsl:text>
        <xsl:value-of select="Round"/>
        <xsl:text> ---</xsl:text>
      </caption>
      <colgroup>
        <col/>
        <col/>
        <col/>
      </colgroup>
      <colgroup>
        <col/>
        <col/>
      </colgroup>
      <colgroup>
        <col/>
        <col/>
        <col/>
      </colgroup>
      <colgroup>
        <col/>
        <col/>
        <col/>
        <col/>
      </colgroup>
      <colgroup>
        <col/>
        <col/>
      </colgroup>
      <colgroup>
        <col/>
        <col/>
      </colgroup>
      <thead>
        <tr>
          <th class="ra"> </th>
          <th class="la"> </th>
          <th>gr</th>
          <th>pts</th>
          <th>val</th>
          <th>sc</th>
          <th>gms</th>
          <th>%</th>
          <th>1</th>
          <th></th>
          <th>0</th>
          <th>abs</th>
          <th>wh.</th>
          <th>bl.</th>
          <th>abs</th>
          <th>bye</th>
        </tr>
      </thead>
      <tbody>
        <xsl:apply-templates select="Player" mode="rank"/>
      </tbody>
    </table>
  </xsl:template>
  <xsl:template match="Player" mode="rank">
    <xsl:variable name="PLAYERID">
      <xsl:value-of select="ID"/>
    </xsl:variable>
    <tr>
      <td class="ra">
        <xsl:value-of select="Pos+1"/>
        <xsl:text>.</xsl:text>
      </td>
      <td class="la">
        <xsl:text disable-output-escaping="yes">
        &lt;a href="javascript:toggleElementVisibility('</xsl:text><xsl:value-of select='ID'/><xsl:text disable-output-escaping="yes">')" title="Show/Hide playerhistory""&gt;
        </xsl:text>
        <img src="info.gif" width="15" border="0" alt="Show/hide player history"/>
        <xsl:text disable-output-escaping="yes">
        &lt;/a&gt;
        </xsl:text>
        <xsl:value-of select="Name"/>
        <xsl:apply-templates select="../../History/Player[ID=$PLAYERID]" mode="hist"/>
      </td>
      <td>
        <xsl:value-of select="Category"/>
      </td>
      <td>
        <xsl:value-of select="Score"/>
      </td>
      <td>
        <xsl:value-of select="Value"/>
      </td>
      <td>
      <xsl:choose>
        <xsl:when test="(PlainScore * 2) mod 2 = 0">
          <xsl:value-of select="floor(PlainScore)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="PlainScore>0.5">
            <xsl:value-of select="floor(PlainScore)"/>
          </xsl:if>
          <xsl:text></xsl:text>
        </xsl:otherwise>
      </xsl:choose>
      </td>
      <td>
        <xsl:value-of select="Games"/>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="Games='0'">
            <xsl:text>-</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="round(Perc)"/>
            <xsl:text>%</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:value-of select="Wins"/>
      </td>
      <td>
        <xsl:value-of select="Draws"/>
      </td>
      <td>
        <xsl:value-of select="Losses"/>
      </td>
       <td>
        <xsl:value-of select="NAdjourned"/>
      </td>
      <td>
        <xsl:value-of select="NWhite"/>
      </td>
      <td>
        <xsl:value-of select="NBlack"/>
      </td>
      <td>
        <xsl:value-of select="NAbsMsg + NOther"/>
      </td>
      <td>
        <xsl:value-of select="NBye"/>
      </td>
    </tr>
  </xsl:template>
  <xsl:template match="History">
    <xsl:apply-templates select="Player" mode="hist"/>
  </xsl:template>
  <xsl:template match="Player" mode="hist">
    <xsl:text disable-output-escaping="yes">
    &lt;div class="playerhistory" style="visibility: hidden;" id="</xsl:text><xsl:value-of select="ID"/><xsl:text disable-output-escaping="yes">"&gt;
    </xsl:text>
      <table>
      <caption style="font-weight:bold">Internal games of <xsl:value-of select="Name"/>:</caption>
        <xsl:apply-templates/>
      </table>
    <xsl:text disable-output-escaping="yes">
      &lt;/div&gt;
    </xsl:text>
  </xsl:template>
  <xsl:template match="Game">
    <tr>
      <td>
        R<xsl:value-of select="Round+1"/>
      </td>
      <td>
        <xsl:value-of select="White"/>
      </td>
      <td>
        -
      </td>
      <td>
        <xsl:value-of select="Black"/>
      </td>
      <td>
        <xsl:value-of select="Res"/>
      </td>
    </tr>
  </xsl:template>
  <xsl:template match="*">
  </xsl:template>
</xsl:stylesheet>
