<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
	<html><head><link rel="STYLESHEET" type="text/css" href="../main.css"/></head>
	<body>
	<xsl:apply-templates select="SevillaRpt"/>
	</body>
	</html>
</xsl:template>

<xsl:template match="SevillaRpt">
	<xsl:apply-templates select="Report/GroupReport"/>
</xsl:template>

<xsl:template match="GroupReport">
	<strong>Ratinglist - <xsl:value-of select="Name"/></strong><br/>
	<xsl:apply-templates select="Ranking"/>
</xsl:template>

<xsl:template match="Ranking">
	<table border="1" rules="none" cellpadding="3">
	<tr>
	<th align="right">Pos</th>
	<th align="left">Name</th>
	<th align="right">Rating</th>
	<th align="right">TPR</th>
	<th align="right">Start</th>
	<th align="right">Score</th>
	<th align="right">Rank</th>
	</tr>
	<xsl:apply-templates select="Player">
		<xsl:sort select="Rating" data-type="number" order="descending"/>
		<xsl:sort select="Score" data-type="number" order="descending"/>
		<xsl:sort select="Name"/>
	</xsl:apply-templates>
	</table>
	<p/>
</xsl:template>

<xsl:template match="Player">
	<tr>
	<td align="right"><xsl:value-of select="position()"/></td>
	<td align="left"><xsl:value-of select="Name"/></td>
	<td align="right"><xsl:value-of select="Rating"/></td>
	<td align="right"><xsl:value-of select="TPR"/></td>
	<td align="right"><xsl:value-of select="IRtg"/></td>
	<td align="right"><xsl:value-of select="Score"/></td>
	<td align="right"><xsl:value-of select="Pos"/></td>
	</tr>
</xsl:template>

</xsl:stylesheet>



