<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
	<!ENTITY frac12 "&#189;">
]>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
	<html><head><link rel="STYLESHEET" type="text/css" href="../main.css"/></head>
	<body>
	<xsl:apply-templates select="SevillaRpt/Report/GroupReport"/>
	</body>
	</html>
</xsl:template>

<xsl:template match="GroupReport">
	<xsl:apply-templates select="Ranking"/>
</xsl:template>

<xsl:template match="Ranking">
	<strong>Ranking - <xsl:value-of select="Name"/></strong><br/>
	<table border="1" rules="none" cellpadding="3" width="550">
	<tr>
	<th align="right">Pos</th>
	<th align="left">Name</th>
	<th align="right">Score</th>
	<th align="right">Gms</th>
	<th align="right">1</th>
	<th align="right">&frac12;</th>
	<th align="right">0</th>
	<th align="right">Perc</th>
	<th align="right">Rtg</th>
	<th align="right">TPR</th>
	<th align="right">Start</th>
	<th align="right">Bhlz</th>
	<th align="right">SB</th>
	<th align="right">S</th>
	<th align="right">R</th>
	</tr>
	<xsl:apply-templates select="Player">
		<xsl:sort select="Pos" data-type="number" order="ascending"/>
	</xsl:apply-templates>
	</table>
	<p/>
</xsl:template>

<xsl:template match="Player">
	<tr>
	<td align="right"><xsl:value-of select="Pos"/></td>
	<td align="left" ><xsl:value-of select="Name"/></td>
	<td align="right"><xsl:value-of select="Score"/></td>
	<td align="right"><xsl:value-of select="Games"/></td>
	<td align="right"><xsl:value-of select="Wins"/></td>
	<td align="right"><xsl:value-of select="Draws"/></td>
	<td align="right"><xsl:value-of select="Losses"/></td>
	<td align="right"><xsl:value-of select="round(Perc*100) div 100"/></td>
	<td align="right"><xsl:value-of select="Rating"/></td>
	<td align="right"><xsl:value-of select="TPR"/></td>
	<td align="right"><xsl:value-of select="IRtg"/></td>
	<td align="right"><xsl:value-of select="Bhlz"/></td>
	<td align="right"><xsl:value-of select="SBrgr"/></td>
	<td align="right"><xsl:value-of select="Balance"/></td>
	<td align="right"><xsl:value-of select="RecBal"/></td>
	</tr>
</xsl:template>

</xsl:stylesheet>



