<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
	<!ENTITY frac12 "&#189;">
]>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
	<html>
	<head><link rel="STYLESHEET" type="text/css" href="../main.css"/></head>
	<body>
	<a name="abstop"/>
	<xsl:apply-templates select="SevillaRpt/Report/GroupReport" mode="header"/>
	<p/>
	<xsl:apply-templates select="SevillaRpt/Report/GroupReport" mode="main"/>
	</body>
	</html>
</xsl:template>

<xsl:template match="GroupReport" mode="header">
	<xsl:variable name="GNUM">
		<xsl:value-of select="ID"/>
	</xsl:variable>
	<a href="#top{$GNUM}"><xsl:value-of select="Name"/></a><br/>
	<xsl:apply-templates select="Ranking" mode="header">
		<xsl:with-param name="GNUM" select="$GNUM"/>
	</xsl:apply-templates>
</xsl:template>

<xsl:template match="GroupReport" mode="main">
	<xsl:variable name="GNUM">
		<xsl:value-of select="ID"/>
	</xsl:variable>
	<a name="top{$GNUM}"/>&nbsp;&nbsp;
	<strong>Score construction by player - <xsl:value-of select="Name"/></strong><p/>
	<xsl:apply-templates select="Ranking" mode="main">
		<xsl:with-param name="GNUM" select="$GNUM"/>
	</xsl:apply-templates>
	<p/>
</xsl:template>

<xsl:template match="Ranking" mode="header">
	<xsl:param name="GNUM"/>
	<xsl:variable name="RNUM">
		<xsl:value-of select="position()"/>
	</xsl:variable>
	<a href="#top{$GNUM}-{$RNUM}">
	Group <xsl:value-of select="$GNUM"/> - Ranking <xsl:value-of select="$RNUM"/> - <xsl:value-of select="Name"/>
	</a><br/>
</xsl:template>

<xsl:template match="Ranking" mode="main">
	<xsl:param name="GNUM"/>
	<xsl:variable name="RNUM">
		<xsl:value-of select="position()"/>
	</xsl:variable>
	<a name="top{$GNUM}-{$RNUM}"></a>
	Group <xsl:value-of select="$GNUM"/> - Ranking <xsl:value-of select="$RNUM"/> - <xsl:value-of select="Name"/>
	<table><tr>
		<td valign="top">
		<table cellspacing="4"><tr><td>
		<table border="1" rules="none" cellpadding="3"><tr><td>
		<xsl:apply-templates select="Player" mode="contents">
			<xsl:with-param name="GNUM" select="$GNUM"/>
			<xsl:with-param name="RNUM" select="$RNUM"/>
			<xsl:sort select="SortName"/>
			<xsl:sort select="Name"/>
		</xsl:apply-templates>
		</td></tr></table>
		</td></tr></table>
	</td>
	<td valign="top">
	<xsl:apply-templates select="Player" mode="data">
		<xsl:with-param name="GNUM" select="$GNUM"/>
		<xsl:with-param name="RNUM" select="$RNUM"/>
	</xsl:apply-templates>
	</td>
	</tr></table>
	<p/>
</xsl:template>

<xsl:template match="Player" mode="contents">
	<xsl:param name="GNUM"/>
	<xsl:param name="RNUM"/>
	<xsl:variable name="PNUM">
		<xsl:value-of select="ID"/>
	</xsl:variable>
	<a href="#pl{$GNUM}-{$RNUM}-{$PNUM}"><xsl:value-of select="Name"/></a>
	<br/>
</xsl:template>

<xsl:template match="Player" mode="data">
	<xsl:param name="GNUM"/>
	<xsl:param name="RNUM"/>
	<xsl:variable name="PNUM">
		<xsl:value-of select="ID"/>
	</xsl:variable>
	<a name="pl{$GNUM}-{$RNUM}-{$PNUM}"></a>
	<strong>
	<xsl:value-of select="position()"/>&nbsp;<xsl:value-of select="Name"/>
	</strong>
	<xsl:text> Value: </xsl:text>
	<xsl:value-of select="PrvVal"/>
	<br/>
	<xsl:apply-templates select="../../History/Player[ID=$PNUM]" mode="hist">
		<xsl:with-param name="GNUM" select="$GNUM"/>
	</xsl:apply-templates>
</xsl:template>

<xsl:template match="Player" mode="hist">
	<xsl:param name="GNUM"/>
	<table border="1" rules="none" cellpadding="2">
	<xsl:apply-templates select="Game|Abs"/>
	</table>
	<a href="#top{$GNUM}">Top of group</a>&nbsp;<a href="#abstop">Top</a>
	<p/>
</xsl:template>

<xsl:template match="Game">
	<xsl:variable name="PNUM">
		<xsl:value-of select="../ID"/>
	</xsl:variable>
	<xsl:variable name="RD">
		<xsl:value-of select="Round"/>
	</xsl:variable>
	<tr>
	<td align="right"><xsl:value-of select="Round"/></td>
	<td><xsl:value-of select="White"/></td>
	<td>-</td>
	<td><xsl:value-of select="Black"/></td>
	<td align="center">
	<xsl:choose>
		<xsl:when test="Res=0">...</xsl:when>
		<xsl:when test="Res=1 or Res=6">1-0</xsl:when>
		<xsl:when test="Res=2 or Res=7">&frac12;-&frac12;</xsl:when>
		<xsl:when test="Res=3 or Res=8">0-1</xsl:when>
		<xsl:when test="Res=4">Adjourned</xsl:when>
		<xsl:when test="Res=9">0-0</xsl:when>
		<xsl:when test="Res=10">Finished</xsl:when>
		<xsl:otherwise>Result <xsl:value-of select="Res"/></xsl:otherwise>
	</xsl:choose>
	</td>
	<td align="right"><xsl:value-of select="Score"/></td>
	<td align="right"><xsl:value-of select="round((
		../../../Ranking/Player[ID=$PNUM]/PrvVal+
		sum(../Game[Round&lt;=$RD]/Score)+
		sum(../Abs[Round&lt;=$RD]/Score)) * 10) div 10"/></td>
	<td align="right"><xsl:value-of select="Pos"/></td>
	</tr>
</xsl:template>

<xsl:template match="Abs">
	<xsl:variable name="PNUM">
		<xsl:value-of select="../ID"/>
	</xsl:variable>
	<xsl:variable name="RD">
		<xsl:value-of select="Round"/>
	</xsl:variable>
	<tr>
	<td align="right"><xsl:value-of select="Round"/></td>
	<td><xsl:value-of select="Player"/></td>
	<td> </td>
	<td> </td>
	<td align="center">
	<xsl:choose>
		<xsl:when test="Reason=0">Absent without message</xsl:when>
		<xsl:when test="Reason=1 or Reason=4">Absent</xsl:when>
		<xsl:when test="Reason=2">Absent for club</xsl:when>
		<xsl:when test="Reason=3">Club other day</xsl:when>
		<xsl:when test="Reason=5 or Reason=16">Bye</xsl:when>
		<xsl:when test="Reason=6">Other 1</xsl:when>
		<xsl:when test="Reason=7">Other 2</xsl:when>
		<xsl:when test="Reason=8">Other 3</xsl:when>
		<xsl:when test="Reason=9 or Reason=17">1</xsl:when>
		<xsl:when test="Reason=10 or Reason=18">&frac12;</xsl:when>
		<xsl:when test="Reason=11 or Reason=19">0</xsl:when>
		<xsl:when test="Reason=12">Correction</xsl:when>
		<xsl:when test="Reason=14">Adjourned</xsl:when>
		<xsl:when test="Reason=15">Extern</xsl:when>
		<xsl:otherwise>Reason <xsl:value-of select="Reason"/></xsl:otherwise>
	</xsl:choose>
	</td>
	<td align="right"><xsl:value-of select="Score"/></td>
	<td align="right"><xsl:value-of select="round((
		../../../Ranking/Player[ID=$PNUM]/PrvVal+
		sum(../Game[Round&lt;=$RD]/Score)+
		sum(../Abs[Round&lt;=$RD]/Score)) * 10) div 10"/></td>
	<td align="right"><xsl:value-of select="Pos"/></td>
	</tr>
</xsl:template>

</xsl:stylesheet>
