<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
	<!ENTITY frac12 "&#189;">
]>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
	<html><head><link rel="STYLESHEET" type="text/css" href="../main.css"/></head>
	<body>
	<xsl:apply-templates select="SevillaRpt/Report/GroupReport"/>
	</body>
	</html>
</xsl:template>

<xsl:template match="GroupReport">
	<strong>Expectancy - <xsl:value-of select="Name"/></strong><br/>
	<table border="1" rules="none" cellpadding="3">
	<tr>
	<th align="right">Pos</th>
	<th align="left">Name</th>
	<xsl:apply-templates select="History/Player[ID='1']" mode="hdr">
		<xsl:sort select="Pos" data-type="number" order="ascending"/>
	</xsl:apply-templates>
	</tr>
	<xsl:apply-templates select="Ranking/Player">
		<xsl:sort select="Pos" data-type="number" order="ascending"/>
	</xsl:apply-templates>
	</table>
	<p/>
</xsl:template>

<xsl:template match="Player">
	<xsl:variable name="PlayerID">
		<xsl:value-of select="ID"/>
	</xsl:variable>
	<tr>
	<td align="right"><xsl:value-of select="Pos"/></td>
	<td align="left" ><xsl:value-of select="Name"/></td>
	<xsl:apply-templates select="../../History/Player[ID=$PLAYERID]" mode="main"/>
	</tr>
</xsl:template>

<xsl:template match="Player" mode="hdr">
	<xsl:apply-templates select="Game|Abs" mode="hdr"/>
</xsl:template>

<xsl:template match="Player" mode="main">
	<xsl:apply-templates select="Game|Abs" mode="main"/>
</xsl:template>

<xsl:template match="Game" mode="hdr">
	<th align="right">
	<xsl:value-of select="Round"/>
	</th>
</xsl:template>

<xsl:template match="Game" mode="main">
	<td align="right">
	<xsl:value-of select="round(20 * (PlainScore - ExpScore))"/>
	</td>
</xsl:template>

<xsl:template match="Abs" mode="hdr">
	<th align="right">
	<xsl:value-of select="Round"/>
	</th>
</xsl:template>

<xsl:template match="Abs" mode="main">
	<td align="right">.</td>
</xsl:template>

</xsl:stylesheet>



