<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
	<!ENTITY frac12 "&#189;">
]>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:key name="cat" match="Ranking/PlayerRanking" use="Category"/>

<xsl:template match="/">
	<html><head><link rel="STYLESHEET" type="text/css" href="../main.css"/></head>
	<body>
	<xsl:apply-templates select="SevillaRpt/Report/GroupReport" mode="CompleteRanking"/>
	<xsl:apply-templates select="SevillaRpt/Report/GroupReport" mode="CategoryRankings"/>
	</body>
	</html>
</xsl:template>

<xsl:template match="GroupReport" mode="CompleteRanking">
	<xsl:apply-templates select="Ranking" mode="CompleteRanking"/>
</xsl:template>

<xsl:template match="Ranking" mode="CompleteRanking">
	<strong>Ranking - <xsl:value-of select="Name"/></strong><br/>
	<table border="1" rules="none" cellpadding="3" width="550">
	<tr>
	<th align="right">Pos</th>
	<th align="left">Name</th>
	<th align="right">Score</th>
	<th align="right">Prt</th>
	<th align="right">1</th>
	<th align="right">&frac12;</th>
	<th align="right">0</th>
	<th align="right">Perc</th>
	<th align="right">Val</th>
	<th align="right">Rtg</th>
	<th align="right">TPR</th>
	<th align="right">Start</th>
	<th align="right">S</th>
	<th align="right">R</th>
	</tr>
		<xsl:for-each select="Player">
			<xsl:apply-templates select=".">
				<xsl:with-param name="pos">
					<xsl:value-of select="position()"/>
				</xsl:with-param>
				<xsl:sort select="Pos" data-type="number" order="ascending"/>
			</xsl:apply-templates>
		</xsl:for-each>
	</table>
	<p/>
</xsl:template>

<xsl:template match="GroupReport" mode="CategoryRankings">
	<xsl:apply-templates select="Ranking" mode="CategoryRankings"/>
</xsl:template>

<xsl:template match="Ranking" mode="CategoryRankings">
	<xsl:for-each select="Player[generate-id(.) = generate-id(key('cat', Category))]">
		<strong>Category: <xsl:value-of select="Category"/></strong><br/>
		<table border="1" rules="none" cellpadding="3" width="550">
		<tr>
		<th align="right">Pos</th>
		<th align="left">Name</th>
		<th align="right">Score</th>
		<th align="right">Prt</th>
		<th align="right">1</th>
		<th align="right">&frac12;</th>
		<th align="right">0</th>
		<th align="right">Perc</th>
		<th align="right">Val</th>
		<th align="right">Rtg</th>
		<th align="right">TPR</th>
		<th align="right">Start</th>
		<th align="right">S</th>
		<th align="right">R</th>
		</tr>
		<xsl:for-each select="key('cat', Category)">
			<xsl:apply-templates select=".">
				<xsl:with-param name="pos">
					<xsl:value-of select="position()"/>
				</xsl:with-param>
				<xsl:sort select="Pos" data-type="number" order="ascending"/>
			</xsl:apply-templates>
		</xsl:for-each>
		</table>
		<p/>
	</xsl:for-each>
</xsl:template>

<xsl:template match="Player">
	<xsl:param name="pos"/>
	<tr>
	<td align="right"><xsl:value-of select="$pos"/></td>
	<td align="left" ><xsl:value-of select="Name"/></td>
	<td align="right"><xsl:value-of select="Score"/></td>
	<td align="right"><xsl:value-of select="Games"/></td>
	<td align="right"><xsl:value-of select="Wins"/></td>
	<td align="right"><xsl:value-of select="Draws"/></td>
	<td align="right"><xsl:value-of select="Losses"/></td>
	<td align="right"><xsl:value-of select="round(Perc * 100) div 100"/></td>
	<td align="right"><xsl:value-of select="PrvVal"/></td>
	<td align="right"><xsl:value-of select="Rating"/></td>
	<td align="right"><xsl:value-of select="TPR"/></td>
	<td align="right"><xsl:value-of select="IRtg"/></td>
	<td align="right"><xsl:value-of select="Balance"/></td>
	<td align="right"><xsl:value-of select="RecBal"/></td>
	</tr>
</xsl:template>

</xsl:stylesheet>



