<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
	<!ENTITY frac12 "&#189;">
]>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
	<html><head><link rel="STYLESHEET" type="text/css" href="../main.css"/></head>
	<body>
	<a name="abstop"/>
	<xsl:apply-templates select="SevillaCmp/Comp/Group" mode="header"/>
	<p/>
	<xsl:apply-templates select="SevillaCmp/Comp/Group" mode="main"/>
	</body>
	</html>
</xsl:template>

<xsl:template match="Group" mode="header">
	<xsl:variable name="GNUM">
		<xsl:value-of select="ID"/>
	</xsl:variable>
	<a href="#top{$GNUM}"><xsl:value-of select="Name"/>
	</a><br/>
</xsl:template>

<xsl:template match="Group" mode="main">
	<xsl:variable name="GNUM">
		<xsl:value-of select="ID"/>
	</xsl:variable>
	<a name="top{$GNUM}"></a>
	<strong>Games - <xsl:value-of select="Name"/></strong><p/>
	<table><tr>
	<td valign="top">
		<strong>&nbsp;&nbsp;Players</strong>
		<table cellspacing="4"><tr><td>
		<table border="1" rules="none" cellpadding="3">
		<tr><td>
		<xsl:apply-templates select="Player">
			<xsl:sort select="Last"/>
			<xsl:sort select="First"/>
			<xsl:sort select="Prefix"/>
		</xsl:apply-templates>
		</td></tr>
		</table>
		</td></tr></table>
	</td>
	<td valign="top">
		<xsl:apply-templates select="Round">
			<xsl:sort select="ID" data-type="number" order="descending"/>
		</xsl:apply-templates>
		<a href="#top{$GNUM}">Top of group</a>&nbsp;<a href="#abstop">Top</a>
	</td>
	</tr></table>
	<p/>
</xsl:template>

<xsl:template match="Player">
	<xsl:value-of select="First"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="Prefix"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="Last"/>
	<br/>
</xsl:template>

<xsl:template match="Round">
	<strong>&nbsp;
	<xsl:value-of select="Name"/>
	<xsl:text> - </xsl:text>
	<xsl:value-of select="Date"/>
	</strong>
	<table cellpadding="3"><tr>
	<td valign="top">
	<table cellpadding="3" border="1" rules="none">
		<xsl:apply-templates select="Game"/>
	</table>
	</td>
	<td valign="top">
	<table cellpadding="3" border="1" rules="none">
		<xsl:apply-templates select="Abs"/>
	</table>
	</td>
	</tr></table>
	<p/>
</xsl:template>

<xsl:template match="Game">
	<tr>
	<xsl:variable name="WHITEID">
		<xsl:value-of select="White"/>
	</xsl:variable>
	<xsl:variable name="BLACKID">
		<xsl:value-of select="Black"/>
	</xsl:variable>
	<td>
	<xsl:value-of select="../../Player[ID=$WHITEID]/First"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="../../Player[ID=$WHITEID]/Prefix"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="../../Player[ID=$WHITEID]/Last"/>
	</td>
	<td>
	<xsl:value-of select="../../Player[ID=$BLACKID]/First"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="../../Player[ID=$BLACKID]/Prefix"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="../../Player[ID=$BLACKID]/Last"/>
	</td>
	<td class="nowrap">
	<xsl:choose>
		<xsl:when test="Res=0">...</xsl:when>
		<xsl:when test="Res=1 or Res=6">1-0</xsl:when>
		<xsl:when test="Res=2 or Res=7">&frac12;-&frac12;</xsl:when>
		<xsl:when test="Res=3 or Res=8">0-1</xsl:when>
		<xsl:when test="Res=4">Adjourned</xsl:when>
		<xsl:when test="Res=9">0-0</xsl:when>
		<xsl:when test="Res=10">Finished</xsl:when>
		<xsl:otherwise>Result <xsl:value-of select="Res"/></xsl:otherwise>
	</xsl:choose>
	</td>
	</tr>
</xsl:template>

<xsl:template match="Abs">
	<tr>
	<xsl:variable name="PLAYERID">
		<xsl:value-of select="Player"/>
	</xsl:variable>
	<td>
	<xsl:value-of select="../../Player[ID=$PLAYERID]/First"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="../../Player[ID=$PLAYERID]/Prefix"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="../../Player[ID=$PLAYERID]/Last"/>
	</td>
	<td>
	<xsl:choose>
		<xsl:when test="Reason=0">Absent without message</xsl:when>
		<xsl:when test="Reason=1 or Reason=4">Absent</xsl:when>
		<xsl:when test="Reason=2">Absent for club</xsl:when>
		<xsl:when test="Reason=3">Club other day</xsl:when>
		<xsl:when test="Reason=5 or Reason=16">Bye</xsl:when>
		<xsl:when test="Reason=6">Other 1</xsl:when>
		<xsl:when test="Reason=7">Other 2</xsl:when>
		<xsl:when test="Reason=8">Other 3</xsl:when>
		<xsl:when test="Reason=9 or Reason=17">1</xsl:when>
		<xsl:when test="Reason=10 or Reason=18">&frac12;</xsl:when>
		<xsl:when test="Reason=11 or Reason=19">0</xsl:when>
		<xsl:when test="Reason=12">Correction</xsl:when>
		<xsl:when test="Reason=14">Adjourned</xsl:when>
		<xsl:when test="Reason=15">Extern</xsl:when>
		<xsl:otherwise>Reason <xsl:value-of select="Reason"/></xsl:otherwise>
	</xsl:choose>
	</td>
	</tr>
</xsl:template>

</xsl:stylesheet>

